
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
entity transco is port (
		nb : in std_logic_vector(3 downto 0);
		dp,ac : in std_logic;
		aff7 : out std_logic_vector(6 downto 0);
		pt : out std_logic
		);
end entity;

architecture behavior of transco is
signal s_aff7 : std_logic_vector(6 downto 0);
begin
	with nb select
				--     gfedcba
		s_aff7 <= 	"0111111" when x"0",
						"0000110" when x"1",
						"1011011" when x"2",
						"1001111" when x"3",
						"1100110" when x"4",
						"1101101" when x"5",
						"1111101" when x"6",
						"0000111" when x"7",
						"1111111" when x"8",
						"1101111" when x"9",
						"1110111" when x"A",
						"1111100" when x"B",
						"0111001" when x"C",
						"1011110" when x"D",
						"1111001" when x"E",
						"1110001" when others; -- cas du F pour M. Darbouli
			aff7 <= s_aff7 when ac='1' else not s_aff7;
			pt <= dp when ac='1' else not dp;
	
end behavior;