-- base pour peripherique PWM
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity pwm_periph is port(
	clk: in std_logic;
	pwm : out std_logic
	);
end entity;

architecture behavior of pwm_periph is 

-- exemple de declaration de constantes si besoin
constant pulse_min_hard : std_logic_vector(31 downto 0):=x"12345678";
constant pulse_max_hard : std_logic_vector(31 downto 0):= x"12345678";

signal pwm_cpt : std_logic_vector(31 downto 0);
signal pwm_cmd : std_logic_vector(31 downto 0):=x"00012863"; -- initialisation à (75875)_10

begin

-- description pwm pour periode 20ms
-- avec horloge à 50MHz


--compteur pour generation periode
process(clk) begin
	if rising_edge(clk) then
		if pwm_cpt<1000000 then
			pwm_cpt <= pwm_cpt+1;
		else
			pwm_cpt<= (others =>'0');
		end if;
	end if;
end process;


-- comparateur pour generation pulse
-- commande par signal pwm_cmd

process(clk) begin
	if rising_edge(clk) then
		if pwm_cpt < pwm_cmd then
			pwm <= '1';
		else
			pwm <= '0';
		end if;
	end if;
end process;

end behavior;
