#ifndef QI2CDEVICE_H
#define QI2CDEVICE_H

#include <QObject>
enum I2C_BUS{ I2C0, I2C1, I2C2 };

class QI2cDevice : public QObject
{
    Q_OBJECT

public:
    explicit QI2cDevice(I2C_BUS bus, unsigned char device,QObject *parent = nullptr);
    virtual int writeRegister(unsigned int registerAddress, unsigned char value);
    virtual int write(unsigned char value);
    virtual unsigned char readRegister(unsigned int registerAddress);
    virtual bool readRegisters(unsigned char number, unsigned char data[] , unsigned char fromAddress = 0);

private:
    virtual void open();
    unsigned char bus;
    unsigned char device;
    unsigned char nbConnectionsErrors;
    int file = {-1};

signals:

};

#endif // QI2CDEVICE_H
