#include "qi2cdevice.h"
#include <string>
#include<fcntl.h>
#include<unistd.h>
#include<sys/ioctl.h>
#include<linux/i2c-dev.h>
using namespace std;

QI2cDevice::QI2cDevice(I2C_BUS bus, unsigned char device, QObject *parent)
    : QObject(parent),bus(bus),device(device)
{
    open();
}

void QI2cDevice::open()
{
    string devname;
    if      (bus==I2C_BUS::I2C0) devname = "/dev/i2c-0";
    else if (bus==I2C_BUS::I2C1) devname = "/dev/i2c-1";
    else if (bus==I2C_BUS::I2C2) devname = "/dev/i2c-2";
    else throw runtime_error("undefined I2C port !");
    // ouverture du périphérique i2c
    if((this->file=::open(devname.c_str(), O_RDWR)) < 0)
    {
        throw runtime_error("unable to open I2C dev file");
    }
    // connection au composant
    if(ioctl(this->file, I2C_SLAVE, this->device) < 0)
    {
        ::close(this->file);
        this->file = -1;
        throw runtime_error("unable to open I2C port");
    }
}

int QI2cDevice::writeRegister(unsigned int registerAddress, unsigned char value)
{
    unsigned char buffer[2];
    buffer[0] = registerAddress;
    buffer[1] = value;
    if(::write(this->file, buffer, 2)!=2){
        perror("I2C: Failed write to the device\n");
        return 1;
    }
    return 0;
}

int QI2cDevice::write(unsigned char value)
{
    unsigned char buffer[1];
    buffer[0]=value;
    if (::write(this->file, buffer, 1)!=1){
        perror("I2C: Failed to write to the device\n");
        return 1;
    }
    return 0;
}

unsigned char QI2cDevice::readRegister(unsigned int registerAddress)
{
    this->write(registerAddress);
    unsigned char buffer[1];
    if(::read(this->file, buffer, 1)!=1){
        perror("I2C: Failed to read in the value.\n");
        return 1;
    }
    return buffer[0];
}

bool QI2cDevice::readRegisters(unsigned char number, unsigned char data[] , unsigned char fromAddress)
{
    this->write(fromAddress);
    if(::read(this->file, data, number)!=(char)number){
        perror("IC2: Failed to read in the full buffer.\n");
        return false;
    }
    return true;
}
