#include "lampemcp23008.h"
enum regAd {IODIR = 0 ,
             IPOL = 1,
             GPINTEN = 2,
             DEFVAL = 3,
             INTCON = 4,
             IOCON = 5,
             GPPU = 6,
             INTF = 7,
             INTCAP = 8,
             GPIO = 9,
             OLAT = 10,
             };

LampeMcp23008::LampeMcp23008(const int _numGpio)
    : i2c(I2C1,0x20), numGpio(_numGpio)
{
    unsigned char value=i2c.readRegister(IODIR);
    value&=~(1<<numGpio);
    i2c.writeRegister(IODIR,value);
}

void LampeMcp23008::setValue(bool nouvelEtat)
{
    unsigned char value=i2c.readRegister(GPIO);
    if (nouvelEtat==false) value|= (1<<numGpio);
    else                   value&=~(1<<numGpio);
    i2c.writeRegister(GPIO,value);
}
