#ifndef BOUTON_H
#define BOUTON_H

#include <QObject>
#include <QTimer>

enum EdgeType{ NONE, RISING, FALLING, BOTH };

class Bouton : public QObject
{
    Q_OBJECT
public:
    explicit Bouton(int _numGpio,EdgeType front,QObject *parent = nullptr);

    int getValue();

private:
    int numGpio;
    int interruptLevel;
    QTimer tictocAntiRebond;

    void getEvent();
    void processAntiRebond();

    static void processInterrupt(int gpio, int level, uint32_t tick, void *userdata);

signals:
    void change();
    void startTimerAntiRebond();

};

#endif // BOUTON_H
