#include "bouton.h"
#include <QDebug>
#include <pigpio.h>

Bouton::Bouton(int _numGpio, EdgeType front, QObject *parent) : QObject(parent)
{
    numGpio=_numGpio;
    gpioInitialise();
    gpioSetMode(numGpio,PI_INPUT);
    tictocAntiRebond.setInterval(4);
    tictocAntiRebond.setSingleShot(true);
    connect(&tictocAntiRebond,&QTimer::timeout,
            this,&Bouton::processAntiRebond);
    connect(this,&Bouton::startTimerAntiRebond,
            &tictocAntiRebond,QOverload<>::of(&QTimer::start));

    interruptLevel=0;
    switch (front)
    {
        case FALLING: interruptLevel=0;break;
        case RISING: interruptLevel=1;break;
        case BOTH: interruptLevel=2;break;
        default : interruptLevel=-1;
    }
    if (interruptLevel!=-1)
    {
        gpioSetISRFuncEx(numGpio,interruptLevel, 0, Bouton::processInterrupt,this);
    }
}

int Bouton::getValue()
{
    return gpioRead(numGpio);
}

void Bouton::getEvent()
{
    if (interruptLevel!=2)    emit startTimerAntiRebond();
    else                      emit change();
}

void Bouton::processAntiRebond()
{
    if (gpioRead(numGpio)!=interruptLevel)  emit change();
}

void Bouton::processInterrupt(int gpio, int level, uint32_t tick, void *userdata)
{
    ((Bouton *)userdata)->getEvent();
}
