#include "jeupong.h"

#include <QPainter>

JeuPong::JeuPong(QWidget *parent)
    : QWidget{parent}
    ,rayonBalle{20}
{
    tictoc.setInterval(10);
    connect(&tictoc,&QTimer::timeout,
            this,&JeuPong::move);
    vitesseBalleX=1;
    vitesseBalleY=2;
    tictoc.start();
}

void JeuPong::paintEvent(QPaintEvent *event)
{
    QPainter painter(this);
    QPen pen;

    pen.setWidth(4);
    pen.setColor(QColor(255,0,0));
    painter.setBrush(QColor(0,220,220));
    painter.setPen(pen);
    painter.drawRect(10,10,width()-20,height()-20);

    pen.setWidth(1);
    pen.setColor(QColor(0,0,0));
    painter.setBrush(QColor(0,200,0));
    painter.setPen(pen);
    QPointF centre(positionBalleX,positionBalleY);
    painter.drawEllipse(centre,rayonBalle,rayonBalle);

}

void JeuPong::resizeEvent(QResizeEvent *event)
{
    positionBalleX=width()/2;
    positionBalleY=height()/2;
    emit sendNewLargeur(width());
}

void JeuPong::move()
{
    positionBalleX+=vitesseBalleX;
    positionBalleY+=vitesseBalleY;
    if (positionBalleX<(rayonBalle+10)) vitesseBalleX=-vitesseBalleX;
    if (positionBalleX>(width()-(rayonBalle+10))) vitesseBalleX=-vitesseBalleX;
    if (positionBalleY<(rayonBalle+10)) vitesseBalleY=-vitesseBalleY;
    if (positionBalleY>(height()-(rayonBalle+10))) vitesseBalleY=-vitesseBalleY;

    update();
}

